/* XOperations.c - MG rev. 2003 - from NL XOP School 1996 */


//********************************************************************************************************//
// PROJECT INCLUDE 
//********************************************************************************************************//
#include "XOP_Globals.h"

#ifdef XOP_ADDS_OPERATIONS 
#include "XOP_Operations.h"
#include "readdata.h"

#ifdef CONNECTED_ON_VME
	#include "PCI-DIO-96-ML.h"
#endif
//********************************************************************************************************//
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=mac68k
#endif
#ifdef _WINDOWS_
	#pragma pack(2)
#endif

//********************************************************************************************************//
// MISC #DEFINEs
//********************************************************************************************************//
#pragma mark Defines



//********************************************************************************************************//
// EXTERNAL OPERATIONS ID
// Operation ID is the number, STARTING FROM ZERO, of the operation in XOP's
// XOPC 1100 resource.
//********************************************************************************************************//
#pragma mark XOPs IDs 

#define START 				0 
#define PAUSE 				1 
#define RESUME	 			2 
#define INIT_8255			3 

//********************************************************************************************************//
// LOCAL PROTOTYPES 
//********************************************************************************************************//
#pragma mark Local Prototypes 


//********************************************************************************************************//
// LOCAL GLOBALS (static lg_)
//********************************************************************************************************//
#pragma mark Local Globals 

 


//********************************************************************************************************//
//  									  CODE  
//********************************************************************************************************//
#pragma mark ----------------------------

//------------------------------------------------------------------------------------
// Routine :Operation_Do
//------------------------------------------------------------------------------------ 
int XOPs_Do(void)
{
    int   result = NO_ERROR;
    short cmdIndex;
    char  cmdName[MAX_OBJ_NAME];  
    
    strncpy(cmdName,(char*)GetXOPItem(0),MAX_OBJ_NAME);  // get external op. name (if needed)
    cmdIndex = (short)GetXOPItem(1);                     // which operation invoked ?

    #ifdef DEBUG_MODE 
        CustomXOPNotice("XOP Name: %s - XOP ID: %d",cmdName,cmdIndex);
    #endif
    
	switch (cmdIndex) {
	
	  case START : // <Replace Me>
		result = Start();
		break;
	     
	  case PAUSE : // <Replace Me>
#ifdef CONNECTED_ON_VME
		Stop();
		//SUSPEND_ACQ;
		//if(a_dump_file_is_defined==1) XOPCloseFile(ReadOrWriteFileRef);
#endif
	       break;
	     
	  case RESUME : // <Replace Me>
#ifdef CONNECTED_ON_VME
		RESUME_ACQ;
#endif
	       break;
	     
	  case INIT_8255 : // <Replace Me>
#ifdef CONNECTED_ON_VME
		Init_8255();
#endif
	       break;
	
	  default   :
	       result = UNKNOWN_DEST_OR_BAD_CMD; // unknow operation
	       break;
	     
	}
	return(result);
}

#endif // -> #ifdef XOP_ADDS_OPERATIONS

//********************************************************************************************************//
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=reset
#endif
#ifdef _WINDOWS_
	#pragma pack()
#endif

